@echo off

rem  this batch file copies a Summary*.log file to an archive subfolder
rem  if it is bigger than SIZELIMIT (in bytes)
rem  used to avoid big (and changing) summary log files for regular statistics.

SET /a SIZELIMIT=500*1024
SET LogDir=Log
SET LogArchive=%LogDir%\Log_Archive

if NOT EXIST %LogArchive% mkdir %LogArchive%

for %%f in (%LogDir%\Summary*.log) do (
	rem %%f   : filename
	rem %%~Zf : filesize in bytes
	echo found: %%f  size: %%~Zf bytes
	if %%~Zf GTR %SIZELIMIT% (
		rem move file and overwrite incomplete file
		MOVE /Y "%LogDir%\%%~nf.*" "%LogArchive%"
	) ELSE (
		rem file has not reaced size threshold - just copy the file and overwrite previous version
		COPY /Y "%LogDir%\%%~nf.*" "%LogArchive%"
	)
	
)

